#install.packages("survival")
#install.packages("survminer")


#library packages
library(survival)
library(survminer)

clusterFile="metabolismcluster.txt"    #Typed result file
cliFile="OS.txt"               #survival data file
setwd("D:\\metabolism\\LGG\\5.NewSubtypeSur")      

#read input file
cluster=read.table(clusterFile, header=T, sep="\t", check.names=F, row.names=1)
cli=read.table(cliFile, header=T, sep="\t", check.names=F, row.names=1)
colnames(cli)=c("futime", "fustat")
cli$futime=cli$futime/365

#data merge
sameSample=intersect(row.names(cluster), row.names(cli))
rt=cbind(cli[sameSample,,drop=F], cluster[sameSample,,drop=F])

#Survival Difference Statistics
length=length(levels(factor(rt$metabolismcluster)))
diff=survdiff(Surv(futime, fustat) ~ metabolismcluster, data = rt)
pValue=1-pchisq(diff$chisq, df=length-1)
if(pValue<0.001){
	pValue="p<0.001"
}else{
	pValue=paste0("p=",sprintf("%.03f",pValue))
}
fit <- survfit(Surv(futime, fustat) ~ metabolismcluster, data = rt)
#print(surv_median(fit))

#Plot a survival curve
bioCol=c("#237AB6","#FA8415","#FF0000","#6E568C","#7CC767","#223D6C","#D20A13","#FFD121","#088247","#11AA4D")
bioCol=bioCol[1:length]
surPlot=ggsurvplot(fit, 
		           data=rt,
		           conf.int=F,
		           pval=pValue,
		           pval.size=6,
		           legend.title="metabolismcluster",
		           legend.labs=levels(factor(rt[,"metabolismcluster"])),
		           legend = c(0.8, 0.8),
		           font.legend=10,
		           xlab="Time(years)",
		           break.time.by = 1,
		           palette = bioCol,
		           surv.median.line = "hv",
		           risk.table=T,
		           cumevents=F,
		           risk.table.height=.25)
pdf(file="survival.OS.pdf",onefile = FALSE,width=7.5,height=5.5)
print(surPlot)
dev.off()


################PFS##############
cliFile="PFI.txt"               #survival data file
#read input file
cluster=read.table(clusterFile, header=T, sep="\t", check.names=F, row.names=1)
cli=read.table(cliFile, header=T, sep="\t", check.names=F, row.names=1)
colnames(cli)=c("futime", "fustat")
cli$futime=cli$futime/365

#data merge
sameSample=intersect(row.names(cluster), row.names(cli))
rt=cbind(cli[sameSample,,drop=F], cluster[sameSample,,drop=F])

#Survival Difference Statistics
length=length(levels(factor(rt$metabolismcluster)))
diff=survdiff(Surv(futime, fustat) ~ metabolismcluster, data = rt)
pValue=1-pchisq(diff$chisq, df=length-1)
if(pValue<0.001){
  pValue="p<0.001"
}else{
  pValue=paste0("p=",sprintf("%.03f",pValue))
}
fit <- survfit(Surv(futime, fustat) ~ metabolismcluster, data = rt)
#print(surv_median(fit))

#Plot a survival curve
bioCol=c("#237AB6","#FA8415","#FF0000","#6E568C","#7CC767","#223D6C","#D20A13","#FFD121","#088247","#11AA4D")
bioCol=bioCol[1:length]
surPlot=ggsurvplot(fit, 
                   data=rt,
                   conf.int=F,
                   pval=pValue,
                   pval.size=6,
                   legend.title="metabolismcluster",
                   legend.labs=levels(factor(rt[,"metabolismcluster"])),
                   legend = c(0.8, 0.8),
                   font.legend=10,
                   xlab="Time(years)",
                   break.time.by = 1,
                   palette = bioCol,
                   surv.median.line = "hv",
                   risk.table=T,
                   cumevents=F,
                   risk.table.height=.25)
pdf(file="survival.PFI.pdf",onefile = FALSE,width=7.5,height=5.5)
print(surPlot)
dev.off()


################PFS##############
cliFile="DSS.txt"               #survival data file
#read input file
cluster=read.table(clusterFile, header=T, sep="\t", check.names=F, row.names=1)
cli=read.table(cliFile, header=T, sep="\t", check.names=F, row.names=1)
colnames(cli)=c("futime", "fustat")
cli$futime=cli$futime/365

#data merge
sameSample=intersect(row.names(cluster), row.names(cli))
rt=cbind(cli[sameSample,,drop=F], cluster[sameSample,,drop=F])

#Survival Difference Statistics
length=length(levels(factor(rt$metabolismcluster)))
diff=survdiff(Surv(futime, fustat) ~ metabolismcluster, data = rt)
pValue=1-pchisq(diff$chisq, df=length-1)
if(pValue<0.001){
  pValue="p<0.001"
}else{
  pValue=paste0("p=",sprintf("%.03f",pValue))
}
fit <- survfit(Surv(futime, fustat) ~ metabolismcluster, data = rt)
#print(surv_median(fit))

#Plot a survival curve
bioCol=c("#237AB6","#FA8415","#FF0000","#6E568C","#7CC767","#223D6C","#D20A13","#FFD121","#088247","#11AA4D")
bioCol=bioCol[1:length]
surPlot=ggsurvplot(fit, 
                   data=rt,
                   conf.int=F,
                   pval=pValue,
                   pval.size=6,
                   legend.title="metabolismcluster",
                   legend.labs=levels(factor(rt[,"metabolismcluster"])),
                   legend = c(0.8, 0.8),
                   font.legend=10,
                   xlab="Time(years)",
                   break.time.by = 1,
                   palette = bioCol,
                   surv.median.line = "hv",
                   risk.table=T,
                   cumevents=F,
                   risk.table.height=.25)
pdf(file="survival.DSS.pdf",onefile = FALSE,width=7.5,height=5.5)
print(surPlot)
dev.off()